IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='GLB_MENSAGEM_PRODUTO') 
BEGIN
	CREATE TABLE [dbo].[GLB_MENSAGEM_PRODUTO](
		[CD_EMP] [int] NOT NULL,
		[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
		[DS_CAD] [VARCHAR](100) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL,
		[MENSAGEM] [VARCHAR](150) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL,
		[DT_INI] [DATETIME] NOT NULL,
		[DT_FIM] [datetime] NOT NULL,
		[CD_USU] [int] NOT NULL,
		[DT_CAD] [datetime] NOT NULL,
		[CD_USU_ATU] [int] NOT NULL,
		[DT_ULT_ATU] [datetime] NOT NULL,
	 CONSTRAINT [PK_GLB_MENSAGEM_PRODUTO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_CTR] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 97) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[GLB_MENSAGEM_PRODUTO]  WITH CHECK ADD  CONSTRAINT [FK_GLB_MENSAGEM_PRODUTO_GLB_USU] FOREIGN KEY([CD_USU])
	REFERENCES [dbo].[GLB_USU] ([CD_USU])

	ALTER TABLE [dbo].[GLB_MENSAGEM_PRODUTO]  WITH CHECK ADD  CONSTRAINT [FK_GLB_MENSAGEM_PRODUTO_GLB_USU_ATU] FOREIGN KEY([CD_USU_ATU])
	REFERENCES [dbo].[GLB_USU] ([CD_USU])
END
